<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Setting;
use App\Models\Category;
use App\Models\User;
use DB;

use Illuminate\Support\Facades\File;

class UserDeleteRequest extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */


    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        return view('home');
    }
    public function view_dashboard(Request $request)
    {   
        //apply filters
        $total_user = 0;
        $active_user = 0;
        $register_user = 0;
        $qualified_user = 0;
        $filter = '1=1'; 
        if(!empty($request->category)){
            $filter .= ' and category_id = "'.$request->category.'"';
        }
        if(!empty($request->facility)){
            $filter .= ' and facility_id = "'.$request->facility.'"';
        }
        if(!empty($request->district)){
            $filter .= ' and district_id = "'.$request->district.'"';
        }
       
        $total_user     =  User::whereRaw($filter)->count(); 
        $active_user    =  User::where('status','1')->whereRaw($filter)->count(); 
        // $register_user  =  User::where('role','3')->whereRaw($filter)->count(); 
        $register_user  =  User::whereRaw($filter)->count(); 
        $qualified_user =  User::where('is_qualified',1)->whereRaw($filter)->count(); 
        
        $district = getDistrict();
        $category = Category::all();
        return view('admin.dashboard',compact('district','category','total_user','active_user','register_user','qualified_user'));
    }

    public function setting()
    {
        $logo =  Setting::where('name', '=', 'logo')->first();
        $favicon =  Setting::where('name', '=', 'favicon')->first();
        return view('admin.setting', compact('logo', 'favicon'));
    }

    public function update_setting(Request $request)
    {


        if ($request->hasfile('logo')) {
            $setting =  Setting::where('name', '=', 'logo')->first();
            if ($setting) {
                $destination = "uploads/logo/" . $setting->value;

                if (File::exists($destination)) {
                    File::delete($destination);
                }
            }
            $file = $request->logo;
            $filename = time() . '.' . $file->getClientOriginalExtension();
            $request->logo->move('uploads/logo', $filename);
            if ($setting) {
                $setting->value = $filename;
                $setting->save();
            } else {
                $data = ['name' => 'logo', 'value' => $filename];
                Setting::create($data);
            }
        }
        if ($request->hasfile('favicon')) {
            $setting =  Setting::where('name', '=', 'favicon')->first();
            if ($setting) {
                $destination = "uploads/logo/" . $setting->value;

                if (File::exists($destination)) {
                    File::delete($destination);
                }
            }
            $file = $request->favicon;
            $filename = time() . '.' . $file->getClientOriginalExtension();
            $request->favicon->move('uploads/logo', $filename);
            if ($setting) {
                $setting->value = $filename;
                $setting->save();
            } else {
                $data = ['name' => 'favicon', 'value' => $filename];
                Setting::create($data);
            }
        }

        $logo =  Setting::where('name', '=', 'logo')->first();
        return view('admin.setting', compact('logo'));
    }
    
    public function accountDeletion(){
        return view('account-deletion');
    }
    public function deleteAccount(Request $request){
        if($request->email==null || $request->confirmation==null){
            return redirect()->back()->with('error','Validation Error! plz fill all requirements to delete your account');
        }
        $user=DB::table('users')->where('email',$request->email)->first();
        if(!$user){
            return redirect()->back()->with('error','User Not Found with the given email!');
        }
        if($user->delete_request==1){    
            return redirect()->back()->with('error','You already send a requets to delete account with the given email!');
        }
        
        $user=DB::table('users')->where('email',$request->email)->update([
        'delete_request' => 1
        ]);
        return redirect()->back()->with('success','Request to delete data successfully!');
    }
    public function delete_request_list(Request $request){
        $users=DB::table('users')->where('delete_request',1)->whereNull('deleted_at')->get();
        return view('admin.DeleteRequest.index',['users'=>$users]);
    }
    public function user_delete(Request $request,$id){
        $User=DB::table('users')->where('id',$id)->update([
            "deleted_at"=>date('Y-m-d h-m-s')
        ]);
        return redirect()->back()->with('success','You Delete User Successfully!');
    }
    
    
}
